% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CaurieMSI.R
\name{CaurieMSI}
\alias{CaurieMSI}
\title{Caurie Moisture Sorption Isotherm}
\usage{
CaurieMSI(WaterAct, AdsorpM, DesorpM)
}
\arguments{
\item{WaterAct}{the numerical value of Water Activity, which ranges from 0 to 1.}

\item{AdsorpM}{the numerical value of the Moisture content of the Adsorption curve, which ranges from 0 to 1.}

\item{DesorpM}{the numerical value of the Moisture content of the Desorption curve, which ranges from 0 to 1.}
}
\value{
the nonlinear regression, parameters, and graphical visualization for the Caurie Moisture Sorption Isotherm model.
}
\description{
Caurie model is a two-parameter isotherm created for calculation of water sorption data of dehydrated foods over a wide range of water activity.
}
\examples{
WaterAct <- c(0.1145,0.2274,0.3265,0.4291,0.6342,0.7385,0.8274,0.9573)
AdsorpM <- c(0.0234, 0.0366, 0.0496, 0.0648, 0.0887, 0.1096, 0.1343, 0.1938)
DesorpM <- c(0.0459, 0.0637, 0.0794, 0.0884, 0.1158, 0.1298,0.1500, 0.1938)
CaurieMSI(WaterAct, AdsorpM, DesorpM)
}
\references{
Caurie, M. (1970) <doi:10.1111/j.1365-2621.1970.tb01571.x> A new model equation for predicting safe storage moisture levels for optimum stability of dehydrated foods. International Journal of Food Science & Technology, 5(3), 301-307.

Caurie, M. (2007) <doi:10.1111/j.1365-2621.2006.01203.x> Hysteresis phenomenon in foods. International Journal of Food Science and Technology, 42(1), 45-49.

Caurie, M. (2011) <doi:10.1007/978-90-481-3585-1_71> Hysteresis in foods. In Encyclopedia of Earth Sciences Series: Vol. Part 4 (p. 384). Springer Netherlands.
}
\author{
Benz L. Rivera

John Carlo F. Panganiban

Kim M. Villacorte

Chester C. Deocaris
}
