% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pspaceDecay.R
\name{expDecay}
\alias{expDecay}
\title{Exponential decay function}
\usage{
expDecay(x, signal = 1, decay = 0.001)
}
\arguments{
\item{x}{A numeric vector of distances (in [0,1]).}

\item{signal}{A single numeric value representing a signal.}

\item{decay}{A decay factor (in [0,1]). This term indicates how much the
\code{signal} decreases as a function of distance in pathway space. 
For example, at a specific distance defined by the \code{pdist} parameter 
(see \code{\link{circularProjection}}), the signal intensity will
be the initial signal multiplied by \code{decay}.
the \code{\link{weibullDecay}} function.}
}
\value{
A numeric vector; if missing 'x', it will return decay function.
}
\description{
The \code{expDecay} function is used by PathwaySpace's methods
for signal convolution and projection.
}
\examples{
x <- seq(0, 2, 0.01)
y <- expDecay(x, signal = 1, decay = 0.5)
plot(x, y)

}
\seealso{
\code{\link{weibullDecay}}, \code{\link{linearDecay}}
}
\author{
Mauro Castro.
}
