% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbms.R
\name{list_crops}
\alias{list_crops}
\title{Retrieve Supported Crops from the Server}
\usage{
list_crops()
}
\value{
A character vector containing the names of supported crops.
}
\description{
Retrieves the list of crops supported by the connected server. If the crop 
list is cached in the internal state, it returns the cached data; otherwise, it 
sends a BrAPI GET request to fetch the crop list.
}
\examples{
if (interactive()) {
  set_qbms_config("https://bms.icarda.org/ibpworkbench")
  login_bms()  # Log in to the server
  list_crops()  # Retrieve list of supported crops
}

}
\seealso{
\code{\link{login}}, \code{\link{set_crop}} to configure and set the current active crop.
}
\author{
Khaled Al-Shamaa (\email{k.el-shamaa@cgiar.org})
}
