% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_hmd_life_tables.R
\name{read_hmd_life_tables}
\alias{read_hmd_life_tables}
\title{Reading HMD life tables}
\usage{
read_hmd_life_tables(
  path = getwd(),
  files = c("mltper_1x1.txt", "fltper_1x1.txt", "bltper_1x1.txt")
)
}
\arguments{
\item{path}{A character. Path to the folder with life tables.}

\item{files}{A character. Names of files with life tables.}
}
\value{
A data frame containing mortality data with columns:
\item{sex}{Character - sex ('male', 'female', or 'both')}
\item{year}{Integer - the year of the data}
\item{age}{Integer - age}
\item{mortality_rate}{Numeric - mortality rate}
\item{life_expectancy}{Numeric - life expectancy}
}
\description{
Reading HMD life tables
}
\examples{
\dontrun{
# Download 'txt' files 
# ("mltper_1x1.txt", "fltper_1x1.txt", "bltper_1x1.txt") 
# for a given country to the working directory
# from https://www.mortality.org after registration.

read_hmd_life_tables(path = getwd())
}
}
\references{
HMD. Human Mortality Database. Max Planck Institute for Demographic Research (Germany), University of California, Berkeley (USA), and French Institute for Demographic Studies (France). Available at www.mortality.org
}
