% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec_tile_map.R
\name{ec_tile_map}
\alias{ec_tile_map}
\title{Draw a grid tile map for East Caucasian languages.}
\usage{
ec_tile_map(
  data = NULL,
  feature_column = "feature",
  title = NULL,
  title_position = "left",
  annotate_feature = FALSE,
  abbreviation = TRUE,
  hide_languages = NULL,
  rename_languages = NULL
)
}
\arguments{
\item{data}{Could be \code{NULL}, then it will print the language template. Otherwise should be a dataframe with language column annotated with some feature. Default value is \code{NULL}.}

\item{feature_column}{Character vector of length 1 which specifies the column in dataframe that contains annotation for the feature to color the language template with.}

\item{title}{Character vector of length 1, which specifies the title of the plot.}

\item{title_position}{Character vector of length 1, which specifies the title's position. Possible values are \code{left}, \code{center}, and \code{right}. Default value is \code{left}.}

\item{annotate_feature}{Logical variable that specifies, whether to add feature values on the tile. This especially make sense in case of numeric features. Default value is \code{FALSE}.}

\item{abbreviation}{Logical variable that specifies, whether use abbreviations for languages specified in the package. Default value is \code{TRUE}.}

\item{hide_languages}{Character variable that specifies, which languages should be removed from the template.}

\item{rename_languages}{This variable maps old language names to their corresponding new names. It can be represented as either:
\itemize{
\item{A named vector, where names are the old language names and values are the corresponding new language names.}
\item{A data frame with two columns: \code{language} (the old language names) and \code{new_language_name} (the corresponding new language names).}}}
}
\value{
a `ggplot2` object
}
\description{
Draw a grid tile map for East Caucasian languages.
}
\examples{
ec_tile_map()

ec_tile_map(ec_languages,
            feature_column = "morning_greetings",
            title = "Morning greetings (Naccarato, Verhees 2021)")

ec_tile_map(ec_languages,
            feature_column = "consonant_inventory_size",
            title = "Consonant inventory size (Moroz 2021)",
            annotate_feature = TRUE)

}
