% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_header_lbl.R
\name{tab_header_lbl}
\alias{tab_header_lbl}
\title{Create a Labeled Header for gt Tables}
\usage{
tab_header_lbl(data, title, subtitle = NULL, label = NULL)
}
\arguments{
\item{data}{A gt table object.}

\item{title}{Title of the table.}

\item{subtitle}{Subtitle of the table.}

\item{label}{Label for referencing the table in LaTeX.}
}
\value{
LaTeX-formatted table header.
}
\description{
This function enhances the gt package's tab_header function by allowing the inclusion
of a label for referencing the table in LaTeX documents.
}
\details{
Be sure to use this function at the end of gt format functions. This function
returns a LaTeX-formatted table header.
}
\examples{
require(gt)
head(iris) |> gt() |> tab_header_lbl(title = "iris",label = "tab:iris") |> cat()
}
