% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinear_CRCA.R
\name{do.crca}
\alias{do.crca}
\title{Curvilinear Component Analysis}
\usage{
do.crca(X, ndim = 2, lambda = 1, alpha = 1, maxiter = 1000, tolerance = 1e-06)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{lambda}{threshold value.}

\item{alpha}{initial value for updating.}

\item{maxiter}{maximum number of iterations allowed.}

\item{tolerance}{stopping criterion for maximum absolute discrepancy between two distance matrices.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{niter}{the number of iterations until convergence.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
}
}
\description{
Curvilinear Component Analysis (CRCA) is a type of self-organizing algorithms for
manifold learning. Like MDS, it aims at minimizing a cost function (\emph{Stress})
based on pairwise proximity. Parameter \code{lambda} is a heaviside function for
penalizing distance pair of embedded data, and \code{alpha} controls learning rate
similar to that of subgradient method in that at each iteration \eqn{t} the gradient is
weighted by \eqn{\alpha /t}.
}
\examples{
## use iris data
data(iris)
set.seed(100)
subid = sample(1:150, 50)
X     = as.matrix(iris[subid,1:4])
label = as.factor(iris[subid,5])

## different initial learning rates
out1 <- do.crca(X,alpha=1)
out2 <- do.crca(X,alpha=5)
out3 <- do.crca(X,alpha=10)

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(out1$Y, col=label, pch=19, main="alpha=1.0")
plot(out2$Y, col=label, pch=19, main="alpha=5.0")
plot(out3$Y, col=label, pch=19, main="alpha=10.0")
par(opar)

}
\references{
\insertRef{demartines_curvilinear_1997}{Rdimtools}

\insertRef{herault_curvilinear_1999}{Rdimtools}
}
\seealso{
\code{\link{do.crda}}
}
\author{
Kisung You
}
\concept{nonlinear_methods}
