#' Comparison of groupings
#'
#' This function compares the real clustering with a clustering obtained with some mathematical method. For each group, this function calculates the number of components that are in the expected grouping that are not in the real grouping. This function adds this value for all groups. It calculates it for all possible combinations of groups and returns the minimum value.
#'
#' @param grouping_exact List. Each component of the list contains a vector with the components of one group. This list represents the actual grouping of the data.
#' @param grouping_obtained List. Each component of the list contains a vector with the components of one group. This list represents the grouping obtained by some mathematical method.
#'
#' @return Returns a number with the quantity of points that are misclassified in the \code{grouping_obtained}.
#'
#'
#'
#' @examples
#'
#'grouping_exact=list(c(1,2,3,4,5),c(6,7),c(8,9))
#'grouping_obtained=list(c(1,3,7),c(2,4,6),c(8,9,5))
#'
#'Number_of_failes(grouping_exact, grouping_obtained)
#' @export




Number_of_failes<-function(grouping_exact, grouping_obtained){

  grouping_exact_ordened<-list()
  for(i in 1:length(grouping_exact)){
    grouping_exact_ordened[[i]]=sort(grouping_exact[[i]])
  }

  grouping_obtained_ordened<-list()
  for(i in 1:length(grouping_obtained)){
    grouping_obtained_ordened[[i]]=sort(grouping_obtained[[i]])
  }

  permutaciones=gtools::permutations(length(grouping_exact), length(grouping_exact))

  error=rep(0,nrow(permutaciones))
  for (i in 1:nrow(permutaciones)) {
  vect=permutaciones[i,]
  error[i]=sum(length(which((grouping_exact_ordened[[1]] %in% grouping_obtained_ordened[[vect[1]]])==FALSE)),
               length(which((grouping_exact_ordened[[2]] %in% grouping_obtained_ordened[[vect[2]]])==FALSE)),
               length(which((grouping_exact_ordened[[3]] %in% grouping_obtained_ordened[[vect[3]]])==FALSE)))
  }

  return(min(error))

}


