#' Center of a cluster using the mean
#'
#' This function calculates the center of a group using the mean of its components.
#'
#' @param data Matrix. The points that we want to group are in the rows.
#' @param grouping List. List with the number of the rows of the data matrix that are in the group \code{[[i]]}.
#'
#'
#'@returns A matrix. The row i contains the centers of the group in \code{[[i]]}.
#'
#'@examples
#'set.seed(451)
#'data=rbind(matrix(runif(20,1,5), nrow = 2, ncol = 10),
#'           matrix(runif(20,20,30), nrow = 2, ncol = 10),
#'           matrix(runif(20,50,70), nrow = 2, ncol = 10))
#'grouping=list(c(1,2), c(3,4),c(5,6))
#'centers_function_mean(data, grouping)
#'
#'
#' @export





centers_function_mean<-function(data, grouping){
    center=matrix(0,length(grouping), dim(data)[2])
    for (i in 1:(length(grouping))){

      if(length(grouping[[i]])==1){
        center[i,]=data[grouping[[i]],]
      }else{
        center[i,]=apply(data[grouping[[i]],],2,mean)
      }
    }
    return(center)
  }
