#' Finding the component in the list that contains a value
#'
#' This function finds in which component of the list \code{lista} the number \code{valor} is.
#'
#' @param lista List. Each component of the list has a vector. The different vector can not contain the same number.
#' @param valor  Number. We want to know in which component of the list \code{lista} the number \code{valor} is.
#'
#' @return Returns a number. Return the number of the component of \code{list} that contains the number \code{valor}.
#'
#' @examples
#'
#'
#'mi_lista <- list(
#'a = c(1, 2, 3),
#'b = c(6,7,8,9),
#'c = c(4,5)
#')
#'
#'valor=7
#'
#'encontrar_componente(mi_lista, valor)
#'
#' @export
#'
#'






encontrar_componente <- function(lista, valor) {
  componentes <- length(lista)
  for (i in 1:componentes) {
    if (valor %in% lista[[i]]) {
      return(i)
    }
  }
  return(NULL)
}
