% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DistanceSameGroup.R
\name{DistanceSameGroup}
\alias{DistanceSameGroup}
\title{Distance between points in the same group}
\usage{
DistanceSameGroup(group1, FHW_output, data, distance)
}
\arguments{
\item{group1}{Number. Number of the group.}

\item{FHW_output}{List. List with:

\itemize{
  \item centers: the information of the centers updated.
  \item grouping: the information of the groups updated. List. Each component of the list contains a vector with the points that belong to that group. More specifically, the list component i has a vector with the numbers of the row of the matrix \code{data} where the points belonging to group i are.
   }}

\item{data}{Matrix with \code{dim(data)[1]} points of \code{dim(data)[2]} dimensions.}

\item{distance}{Function. This function designs how the distance is going to be calculated. It must have as input two vectors and as output the distance of these vectors.}
}
\value{
Returns a number, the value of the maximum distance between pair of points of the group.
}
\description{
This function calculates the distance between points in the same group. This function calculates the distance between the pair of points in the group. Then, takes the maximum distance.
}
\examples{

set.seed(451)
data=rbind(matrix(runif(30,1,5), nrow = 3, ncol = 10),
          matrix(runif(20,20,30), nrow = 2, ncol = 10),
          matrix(runif(20,50,70), nrow = 2, ncol = 10))
k=3
seed=5


FHW_output=Hartigan_and_Wong(data,
                            Euclideandistance,
                            k,
                            centers_function_mean,
                            init_centers_random,
                            seed=seed,
                            10)

DistanceSameGroup(2,  FHW_output, data, Euclideandistance)
}
