% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_auxiliary.R
\name{plot_lognormalvar}
\alias{plot_lognormalvar}
\title{Plots a lognormal variable}
\usage{
plot_lognormalvar(m, sd, label = NULL, logtransform = FALSE, color = "black")
}
\arguments{
\item{m}{A vector of means of the distribution.}

\item{sd}{A vector of standard deviations of the distribution.}

\item{label}{Name of the variable to be used as x-axis label.}

\item{logtransform}{Indicates whether the mean and standard deviation are in
lognormal (TRUE) or normal (FALSE) space.}

\item{color}{A vector of colors.}
}
\value{
A plot of the probability distribution function. Vertical dotted line
indicates mean of distribution. This function can plot multiple curves when multiple means
and standard deviations are provided.
}
\description{
Plots the probability distribution function of a lognormal variable from the
mean and standard deviation in either transformed (normal) or untransformed space.
}
\examples{
mu <- 0.5
stddev <- 0.1
plot_lognormalvar(mu, stddev) # mean of plot should be 0.5

#logtransformed parameters
mu <- 0
stddev <- 0.1
plot_lognormalvar(mu, stddev, logtransform = TRUE) # mean of plot should be 1
}
\seealso{
\code{\link[=plot_betavar]{plot_betavar()}} \code{\link[=plot_steepness]{plot_steepness()}}
}
\author{
Q. Huynh
}
