% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare.R
\name{NW_prepare}
\alias{NW_prepare}
\title{Prepare data for SFHNV trees and forests}
\usage{
NW_prepare(data)
}
\arguments{
\item{data}{A \code{data.frame} containing demand \code{D}, quantile \code{Q}, and feature columns.}
}
\value{
A list with prepared matrices (\code{X}), outcomes (\code{D}, \code{Q}), binary indicators (\code{z}),
feature names, and the dimensions \code{n} and \code{p}.
}
\description{
Converts a data frame with outcome quantities into a numeric matrix representation
used by the Structural Forest for the Heterogeneous Newsvendor (SFHNV) estimators.
}
\examples{
data <- data.frame(x1 = rnorm(100), x2 = rnorm(100), D = rnorm(100), Q = rnorm(100))
prep <- NW_prepare(data)
str(prep)
}
