#' Compute Joe Copula Parameter from Kendall's Tau
#'
#' Computes the Joe copula dependence parameter based on Kendall's tau.
#'
#' @param tau Numeric, Kendall's tau correlation coefficient.
#' @return Numeric, estimated Joe copula parameter.
#' @importFrom copula joeCopula tau
#' @export
#'
#' @examples joe.theta(mean(cor(cbind(u[[1]], u[[2]], u[[3]]), method = "kendall")))
#'
joe.theta <- function(tau){
  theta.grid <- seq(1, 10, by = 0.001)
  theta.grid <- theta.grid[!theta.grid == 1]
  theta.joe <- rep(NA, length(theta.grid))
  for (i in 1:length(theta.joe)){
    theta.joe[i] <- copula::tau(copula::joeCopula(theta.grid[i])) - tau
  }
  theta_joe <- theta.grid[which.min(abs(theta.joe))]
  return(theta_joe)

}
