\name{adjustSize}
\Rdversion{1.3}
\alias{adjustSize}
\title{
Adjustment of the sample size in case it is externally given
}
\description{
The optimisation step finds the best stratification that minimises the sample size under given precision constraints.
In some cases, the goal is not the minimisation of the sample size, as this value is given externally. Nonetheless, it is
still possible to perform the optimisation of the stratification, and then to proceed to an adjustment of the sample size
by increasing or decreasing it proportionally in each resulting stratum.
}
\usage{
adjustSize(size, strata, cens=NULL, minnumstr=2)
}
\arguments{
  \item{size}{
The value of the sample size given externally
	}
  \item{strata}{
The new (aggregated) strata generated by the function 'optimizeStrata'
	}
  \item{cens}{
Flag indicating the presence of a take-all stratum
	}
  \item{minnumstr}{
Indicates the minimum number of units that must be allocated in each stratum. Default is 2.
}
}
\value{
The strata generated by the function 'optimizeStrata', where the variable 'SOLUZ' has been adjusted by taking into account the total required sample size
}

\author{
Giulio Barcaroli
}

\examples{
\dontrun{
library(SamplingStrata)
data(swisserrors)
data(swissstrata)
solution <- optimizeStrata (
	errors = swisserrors,
	strata = swissstrata,
)
# 
sum(solution$aggr_strata$SOLUZ)
# Adjustment of total sample size (decreasing)
adjustedStrata <- adjustSize(size=300,strata=solution$aggr_strata)
sum(adjustedStrata$SOLUZ)
# Adjustment of total sample size (increasing)
adjustedStrata <- adjustSize(size=500,strata=solution$aggr_strata)
sum(adjustedStrata$SOLUZ)
}
}

\keyword{ survey }