% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trivial_niche.R
\name{trivial_niche}
\alias{trivial_niche}
\title{trivial niche model}
\usage{
trivial_niche(x)
}
\arguments{
\item{x}{gradient value at which the niche is evaluated}
}
\value{
A vector of the same length as x with all entries replaced by 1.
}
\description{
Models a trivial niche, meaning the niche of a taxon that has no environmental preferences. Mainly used as default input to \code{last_occ} and \code{range_offset}. When passed to \code{apply_niche}, this will effectively result in no niche model being applied.
}
\examples{
x = p3(rate = 10, from = 0, to = 1) # model fossil occurrences
# apply trivial niche model
y = apply_niche(x, niche_def = trivial_niche, gc = trivial_gradient)
all(x == y) # true, no fossils were removed

}
\seealso{
\code{\link[=last_occ]{last_occ()}},  \code{\link[=range_offset]{range_offset()}}, \code{\link[=trivial_gradient]{trivial_gradient()}} and \code{\link[=apply_niche]{apply_niche()}}
}
