% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HR.WCE.R
\name{HR.WCE}
\alias{HR.WCE}
\title{Obtain a hazard ratio (HR) from a WCE Cox proportional hazards model}
\usage{
HR.WCE(x, vecnum, vecdenom, allres = FALSE)
}
\arguments{
\item{x}{A \code{WCE} object.}

\item{vecnum}{A vector of time-dependent exposures corresponding to a scenario of interest (numerator of the HR).}

\item{vecdenom}{A vector of time-dependent exposures corresponding to a scenario for the reference category (denominator of the HR).}

\item{allres}{Logical. If FALSE, prints the results using the best model from the WCE object, i.e. among the models fitted with the different numbers of interior knots requested by \code{nknots}, based on AIC or BIC as specified in the \code{WCE} call. If TRUE, prints the results for all the estimated models available from the WCE object. Default to FALSE.}
}
\value{
Returns one or several hazard ratios. Inference may be obtained by bootstrap and has to be coded separately (please see \code{WCE} for an example).
}
\description{
This function extracts the estimated coefficients from a WCE object.
}
\details{
Both \code{vecnum} and \code{vecdenom} need to be of the same length as the weight function \code{cutof} argument used in the call to WCE. The first value of each vector represents the exposure today (t1) and subsequent values represent the exposures in the past. The hazard ratio computed by \code{HR.WCE} corresponds to the ratio of the weighted cumulative exposures for the scenario of interest (\code{vecnum}) and the reference scenario (\code{vecdenom}). It corresponds to equation (8) of Sylvestre and Abrahamowicz (2009).
}
\examples{
wce <- WCE(drugdata, "Cox", 1, 90, constrained = "R", id = "Id", event = "Event",
start = "Start", stop = "Stop", expos = "dose",covariates = c("age", "sex"))
# Exposed at a dose of 1 (constant) vs. unexposed over the time window of 90 days
scenario1 <- rep(1, 90)
scenario2 <- rep(0, 90)
HR.WCE(wce, vecnum = scenario1, vecdenom = scenario2)

}
\references{
Sylvestre, M. P., & Abrahamowicz, M. (2009). Flexible modeling of the cumulative effects of time-dependent exposures on the hazard. Statistics in medicine, 28(27), 3437-3453.
}
