\name{WeibullModiAMR}
\alias{WeibullModiAMR}
\title{Fit Modified Weibull-Type Distributions}
\description{
Fits eight modified Weibull-type distributions using maximum likelihood estimation.
Returns estimates, log-likelihood, AIC, and BIC.
}
\usage{
WeibullModiAMR(x, dist = "Alwasel2009")
}
\arguments{
  \item{x}{Numeric vector of positive data.}
  \item{dist}{Character; choose one of:
  \code{"Rangoli2023"}, \code{"Peng2014"}, \code{"Lai2003"},
  \code{"Xie1996"}, \code{"Sarhan2009"}, \code{"Rangoli2025"},
  \code{"Mustafa2012"}, \code{"Alwasel2009"}.}
}
\value{
A list containing:
  \item{estimates}{Estimated parameters.}
  \item{loglik}{Maximized log-likelihood.}
  \item{AIC}{Akaike Information Criterion.}
  \item{BIC}{Bayesian Information Criterion.}
}

\section{Distributions}{
The following modified Weibull-type distributions are included in the package,
along with their respective probability density functions (PDFs) and references:

\itemize{
  \item \strong{Rangoli2023:} \deqn{f(x) = (a b x^{b-1} + \frac{g}{x^2}) \exp(a x^b - \frac{g}{x}) \exp(-\exp(a x^b - \frac{g}{x}))}
  \emph{Reference:} Rangoli, A. M. (2024).  \doi{10.22271/maths.2024.v9.i4b.1771}

  \item \strong{Peng2014:} \deqn{f(x) = \alpha \exp(-\lambda/x) (\beta x^{\beta-1} + \lambda x^{\beta-2}) \exp(-\alpha x^{\beta} \exp(-\lambda/x))}
  \emph{Reference:} Peng, X. (2014). \doi{10.1016/j.ress.2013.07.007}

  \item \strong{Lai2003:} \deqn{f(x) = a (b + l x) x^{b-1} \exp(l x) \exp(-a x^{b} \exp(l x))}
  \emph{Reference:} Lai, C. D. (2003). \doi{10.1109/TR.2002.805788}

  \item \strong{Xie1996:} \deqn{f(x) = (a b x^{b-1} + g l x^{l-1}) \exp(-(a x^{b} + g x^{l}))}
  \emph{Reference:} Xie, M. (1996). \doi{10.1016/0951-8320(95)00149-2}

  \item \strong{Sarhan2009:} \deqn{f(x) = (a b x^{b-1} + g) \exp(-(a x^{b} + g x))}
  \emph{Reference:} Sarhan, A. M. (2009). \url{https://www.researchgate.net/publication/228695122_Modified_Weibull_distribution}

  \item \strong{Rangoli2025:} \deqn{f(x) = (g l x^{l-1} + a b x^{b-1} \exp(x^{b}) / b^{a}) \exp(-((a/b^{a})(\exp(x^{b}) - 1) + g x^{l}))}
  \emph{Reference:} Rangoli, A. M. (2025). \doi{10.7759/cureus.77347}

  \item \strong{Mustafa2012:} \deqn{f(x) = (\alpha \beta x^{\beta-1} + \lambda \exp(-\lambda x)) \exp(-(\alpha x^{\beta} + \lambda x))}
  \emph{Reference:} Mustafa, A. (2012). \doi{10.1016/j.ress.2013.07.007}

  \item \strong{Alwasel2009:} \deqn{f(x) = (a + b g x^{g-1}) \exp(-(a x + b x^{g}))}
  \emph{Reference:} Alwasel, I. (2009). \url{https://www.researchgate.net/publication/228817485_Statistical_Inference_of_a_Competing_Risks_Model_with_Modified_Weibull_Distributions}
}
}

\examples{
# Load your package
library(WeibullModiAMR)

# Example: Fit Rangoli2023 distribution
x <- rexp(50, rate = 1)
res <- WeibullModiAMR(x, dist = "Rangoli2023")
print(res)
}
