% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_weighting.R
\name{item_weighting}
\alias{item_weighting}
\title{Item Weighting According to the Kilic & Dogan (2019) Method}
\usage{
item_weighting(x, threshold = 1)
}
\arguments{
\item{x}{A numeric data.frame or matrix. Rows should represent individuals, and columns should represent items.
The method was designed for dichotomous (0-1) data.}

\item{threshold}{The threshold value for applying the weighting. The article uses a value of 1.}
}
\value{
A new data.frame of the same dimensions with weighted scores.
}
\description{
This function weights an item-response matrix using the method proposed by
Kilic & Dogan (2019). The method is based on adding the item reliability
index (corrected item-total correlation) to the original score if the sum
of the person's average score and the item's difficulty index exceeds a
certain threshold (default is 1).
}
\examples{
## Example 1: Dichotomous Data (as in the original study)
set.seed(123)
n_students_dich <- 200
n_items_dich <- 10
dich_data <- as.data.frame(
  matrix(
    rbinom(n_students_dich * n_items_dich, 1, 0.6),
    nrow = n_students_dich
  )
)
cat("--- Original Dichotomous Data (Head) ---\n")
print(head(dich_data))

weighted_dich <- item_weighting(dich_data)
cat("\n--- Weighted Dichotomous Data (Head) ---\n")
print(head(weighted_dich))


## Example 2: 5-Point Likert-Type Data
# Note: The function was designed for 0-1 data. With Likert data,
# the person's average score will likely be > 1, causing the weighting
# condition to be met for almost all responses.
set.seed(456)
n_students_likert <- 150
n_items_likert <- 15
likert_data <- as.data.frame(
  matrix(
    sample(1:5, size = n_students_likert * n_items_likert, replace = TRUE),
    nrow = n_students_likert
  )
)
cat("\n--- Original 5-Point Likert Data (Head) ---\n")
print(head(likert_data))

weighted_likert <- item_weighting(likert_data)
cat("\n--- Weighted 5-Point Likert Data (Head) ---\n")
print(head(weighted_likert))
}
\references{
Kilic, A. F., & Dogan, N. (2019). The effect of item weighting on reliability and validity.
Journal of Measurement and Evaluation in Education and Psychology, 10(2), 149-164. DOI: 10.21031/epod.516057
}
