% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighted_mean_score.R
\name{weighted_mean_score}
\alias{weighted_mean_score}
\title{Calculate Weighted Mean Scores Using the Kılıç & Doğan (2019) Method}
\usage{
weighted_mean_score(x, threshold = 1)
}
\arguments{
\item{x}{A numeric data.frame or matrix. Rows should represent individuals,
and columns should represent items. The method was designed for
dichotomous (0-1) data.}

\item{threshold}{The threshold value for applying the weighting, passed to
the `item_weighting` function. The article uses a value of 1.}
}
\value{
A numeric vector containing the weighted mean score for each
  individual (each row).
}
\description{
This function first weights an item-response matrix using the
`item_weighting` function and then calculates the mean score for
each individual.
}
\examples{
# Generate sample dichotomous data
set.seed(123)
my_data <- as.data.frame(
  matrix(rbinom(200 * 10, 1, 0.6), nrow = 200)
)

# Calculate weighted mean scores
mean_scores <- weighted_mean_score(my_data, threshold = 1)

# View the first few mean scores
cat("--- Weighted Mean Scores (Head) ---\n")
print(head(mean_scores))

# Compare with simple unweighted mean scores
unweighted_means <- rowMeans(my_data)
cat("\n--- Unweighted Mean Scores (Head) ---\n")
print(head(unweighted_means))
}
