% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint-method.R
\name{confint,aRD-method}
\alias{confint,aRD-method}
\title{Estimating confidence intervals of the estimated model parameters of \code{aRD()}}
\usage{
\S4method{confint}{aRD}(
  object,
  parm,
  level = 0.95,
  method = "wald",
  R = 1000L,
  maxit = NULL,
  verbose = NULL,
  solver = NULL,
  eps_abs = NULL,
  eps_rel = NULL,
  polish_final = NULL,
  conswitch = NULL,
  use_nearPD = NULL
)
}
\arguments{
\item{object}{An object of class \code{"aRD"}.}

\item{parm}{A specification of which model parameters are to be given confidence intervals, either a vector of numbers or a vector of names. If missing, all model parameters are considered.}

\item{level}{A numeric value that indicates the level of confidence.}

\item{method}{A character giving the estimation method of the confidence intervals (\code{"bca"} or \code{"wald"}).}

\item{R}{A positive integer giving the number of bootstrap replicates.}

\item{maxit}{A positive integer giving the maximum number of iterations.}

\item{verbose}{Logical; if TRUE, a detailed output is printed, including iteration logs,
objective values and solver messages (e.g., from \code{osqp}).}

\item{solver}{A character string specifying the solver to use. Options are "osqp" or "quadprog".}

\item{eps_abs}{Absolute tolerance for solver convergence (only used with "osqp").}

\item{eps_rel}{Relative tolerance for solver convergence (only used with "osqp").}

\item{polish_final}{Logical; if TRUE and solver is "osqp", performs a final polish step.}

\item{conswitch}{Specifies how the constraint matrix is constructed:
\describe{
  \item{1 (default)}{Generates all possible combinations of minimum and maximum values for the predictors (excluding the intercept), resulting in \eqn{2^{m-1}} constraints. 
  This formulation constrains model predictions within the observed data range, making it suitable for both risk factor identification and prediction (prognosis).}
  \item{0}{Uses the raw design matrix \code{x} as the constraint matrix, resulting in \eqn{n} constraints. 
  This is primarily suitable for identifying risk factors, but not for prediction tasks, as predictions are not bounded to realistic ranges.}
}}

\item{use_nearPD}{Logical; if \code{TRUE}, the Hessian matrix is projected to the nearest positive definite matrix 
using \code{Matrix::nearPD()} to ensure numerical stability, especially when using solvers that require a positive definite matrix 
(e.g., \code{quadprog}). If \code{FALSE}, the raw Hessian is used directly, which is faster but may lead to numerical issues 
if the matrix is not positive definite. Default is \code{TRUE}.}
}
\value{
A matrix with columns giving the lower and upper confidence limits of each estimated model parameter.
}
\description{
For objects of class \code{"aRD"}, \code{confint()} estimates confidence intervals of the estimated model parameters of \code{aRD()}.
}
\details{
\code{confint} provides Wald (default) and bias-corrected accelerated bootstrap confidence intervals of the estimated model parameters of \code{aRD()}.
}
\author{
Thomas Wolf, Julius Johannes Weise, Stefan Wagenpfeil
}
