% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_join_paths_to_query.R
\name{add_join_paths_to_query}
\alias{add_join_paths_to_query}
\title{Add Join Paths to Query}
\usage{
add_join_paths_to_query(
  conn,
  filter_statements,
  join_path_list,
  argument_sequence,
  requested_vars = NULL
)
}
\arguments{
\item{conn}{The connection object or database connection string.}

\item{filter_statements}{The SQL-Filter statements extracted from the filter arguments list via 'get_filter_statement()'.}

\item{join_path_list}{A list representing the join path. Each element of the list should be a data frame
describing a step in the join path with columns: "table_to_join", "method", and "common_var".}

\item{argument_sequence}{A numeric vector representing the AND/OR sequence of arguments.}

\item{requested_vars}{A character vector specifying the variables to be selected from the final query result.
If \code{NULL}, all variables are selected.}
}
\value{
A SQL query string that represents the joined tables and requested variables.
}
\description{
This function generates an SQL query based on a specified connection, argument, and join path list.
It constructs a query that performs joins on multiple tables according to the provided join path,
incorporating requested variables and filter conditions as needed.
}
