% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{process_groads}
\alias{process_groads}
\title{Process roads data}
\usage{
process_groads(path = NULL, extent = NULL, ...)
}
\arguments{
\item{path}{character(1). Path to geodatabase or shapefiles.}

\item{extent}{numeric(4) or SpatExtent giving the extent of the raster
if \code{NULL} (default), the entire raster is loaded}

\item{...}{Placeholders.}
}
\value{
a \code{SpatVector} object
}
\description{
The \code{process_groads()} function imports and cleans raw road data,
returning a single \code{SpatVector} object.
}
\note{
U.S. context. The returned \code{SpatVector} object contains a
\verb{$description} column to represent the temporal range covered by the
dataset. For more information, see \url{https://data.nasa.gov/dataset/global-roads-open-access-data-set-version-1-groadsv1}.
}
\examples{
## NOTE: Example is wrapped in `\dontrun{}` as function requires a large
##       amount of data which is not included in the package.
\dontrun{
groads <- process_groads(
  path = "./data/groads_example.shp"
)
}
}
\author{
Insang Song
}
