% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anscombise_gif.R
\name{anscombise_gif}
\alias{anscombise_gif}
\title{Animation of several Anscombised datasets}
\usage{
anscombise_gif(
  x,
  which = 1,
  idempotent = TRUE,
  theme_name = "classic",
  ease = "cubic-in-out",
  transition_length = 3,
  state_length = 1,
  wrap = TRUE
)
}
\arguments{
\item{x}{A list of input datasets.  Each one must be a suitable argument
\code{x} for \code{\link{anscombise}}.}

\item{which, idempotent}{Vectors that provide the arguments of the same names
to \code{\link{anscombise}} for each dataset.  If necessary, \code{\link{rep_len}} is used to
replicate these arguments so that they each have length \code{length(x)}.}

\item{theme_name}{A character scalar used to set the
\code{\link[ggplot2:ggtheme]{ggtheme}}.
One of \code{"grey"}, \code{"gray"}, \code{"bw"}, \code{"linedraw"}, \code{"light"}, \code{"dark"},
\code{"minimal"}, \code{"classic"}, \code{"void"} or \code{"test"}.}

\item{ease}{A character scalar passed to \code{\link[gganimate:ease_aes]{ease_aes}}
to control how the points move in transitioning from one dataset to
the next.}

\item{transition_length, state_length, wrap}{Arguments passed to
\code{\link[gganimate:transition_states]{transition_states}}.}
}
\value{
An object of class \code{c("gganim", "gg", "ggplot")} with an additional
attribute \code{new_data} that is a data frame with 3 variables, \code{x}, \code{y} and
\code{dataset} containing the datasets output from \code{anscombise}.

The returned object may be displayed using by typing its name,
e.g., \code{anim} or saved as a GIF file using
\code{\link[gganimate:anim_save]{anim_save}}, e.g.,
\code{gganimate::anim_save("anscombe.gif", anim)}.
}
\description{
Create an animation to show datasets that share sample summary statistics
with \link[datasets:anscombe]{Anscombe's quartet}.
}
\details{
For this function to work the packages
\code{\link[ggplot2:ggplot2-package]{ggplot2}} and
\code{\link[gganimate:gganimate-package]{gganimate}} must be installed.
}
\examples{
# Animate some Anscombe-like datasets produced using input1 to input8
x <- list(input1, input2, input3, input4, input5, input6, input7, input8)
idem <- c(FALSE, TRUE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE)
anim <- anscombise_gif(x, idempotent = idem)
}
\seealso{
\code{\link{anscombise}} modifies a dataset so that it shares sample summary
statistics with \link[datasets:anscombe]{Anscombe's quartet}.

\code{\link{input_datasets}}: \code{input1} to \code{input8} for some input datasets
of the same size as those in Anscombe's quartet.
}
