% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuctionClasses.R
\docType{class}
\name{Auction-Classes}
\alias{Auction-Classes}
\alias{Auction2ndCap-class}
\alias{Auction2ndLogit-class}
\alias{Auction2ndLogitNests-class}
\alias{Auction2ndLogitALM-class}
\title{Class \dQuote{Auction}}
\description{
The \dQuote{Auction2ndCap} class contains all the information needed to
calibrate a 2nd price auction with capacity constraints

The \dQuote{Auction2ndLogit} class contains all the information needed to
calibrate a Logit
demand system and perform a merger simulation analysis under the assumption that
firms are setting offers in a 2nd-score auction.

The \dQuote{Auction2ndLogitNests} class contains all the information needed to
calibrate a Nested Logit
demand system and perform a merger simulation analysis under the assumption that
firms are setting offers in a 2nd-score auction.

The \dQuote{Auction2ndLogitALM} class contains all the information needed to
calibrate a Logit
demand system with unobserved outside share and perform a merger simulation analysis under the assumption that
firms are setting offers in a 2nd-score auction.

Below, let k denote the number of firms.
}
\section{Slots}{

\describe{
\item{\code{capacities}}{A length k vector of firm capacities.}

\item{\code{margins}}{A length k vector of product margins, some of which may
equal NA.}

\item{\code{prices}}{A length k vector of product prices.}

\item{\code{reserve}}{A length 1 vector equal to observed buyer's
reserve price. May equal NA.}

\item{\code{shareInside}}{A length 1 vector equal to the
probability that a buyer does not select the outside option. May equal NA.}

\item{\code{sellerCostCDF}}{A length 1 character vector equal to
the name of the function that calculates the Cumulative
Distribution (CDF) of SellerCosts.}

\item{\code{sellerCostCDFLowerTail}}{A length 1 logical vector equal to
TRUE if the  probabilities are P[X <= x], otherwise, P[X > x].}

\item{\code{sellerCostPDF}}{A function returning the Probability Density
of Seller Costs.}

\item{\code{sellerCostBounds}}{The bounds on the seller's CDF.}

\item{\code{sellerCostParms}}{The parameters of the seller's CDF.}

\item{\code{buyerValuation}}{Buyer's self-supply cost.}

\item{\code{reservePre}}{Buyer's optimal pre-merger reservation price.}

\item{\code{reservePost}}{Buyer's optimal post-merger reservation
price.}

\item{\code{mcDelta}}{A length k vector equal to the proportional
change in a firm's capacity following the merger.}

\item{\code{parmsStart}}{A vector of starting values.}
}}

\section{Objects from the Class}{

Auction2ndCap: Objects can be created by using the constructor function \code{\link{auction2nd.cap}}.

Auction2ndLogit: Objects can be created by using the constructor function \code{\link{auction2nd.logit}}.

Auction2ndLogitNests: Objects can be created by using the constructor function \code{\link{auction2nd.logit.nests}}.

Auction2ndLogitALM: Objects can be created by using the constructor function \code{\link{auction2nd.logit.alm}}.
}

\section{Extends}{

Auction2ndCap: Class \code{\linkS4class{Antitrust}}, directly.

Auction2ndLogit: Class \code{\linkS4class{Logit}}, directly.
Class \code{\linkS4class{Bertrand}}, by class \code{\linkS4class{Logit}}, distance 2.
Class \code{\linkS4class{Antitrust}}, by class \code{\linkS4class{Bertrand}}, distance 3.

Auction2ndLogitALM: Class \code{\linkS4class{Auction2ndLogit}}, directly.
Class \code{\linkS4class{Logit}}, distance 2.
Class \code{\linkS4class{Bertrand}}, by class \code{\linkS4class{Logit}}, distance 3.
Class \code{\linkS4class{Antitrust}}, by class \code{\linkS4class{Bertrand}}, distance 4.
}

\examples{
showClass("Auction2ndCap")           # get a detailed description of the class
showClass("Auction2ndLogit")           # get a detailed description of the class
showClass("Auction2ndLogitALM")           # get a detailed description of the class
}
\author{
Charles Taragin \email{ctaragin+antitrustr@gmail.com}
}
\keyword{classes}
