% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outlier_test.R
\name{outlier_test}
\alias{outlier_test}
\title{Identify outliers}
\usage{
outlier_test(model, n = stats::nobs(model), alpha = 0.05)
}
\arguments{
\item{model}{A fitted model object from the
\code{\link[stats]{lm}} function.}

\item{n}{The number of outliers to return. The default is
all outliers.}

\item{alpha}{The Bonferroni-adjusted threshold at which
an outlier is identified. The default is \code{0.05}.}
}
\value{
A data frame with the outliers.
}
\description{
\code{outlier_test} returns the observations identified
as an outlier based on the Bonferroni correction for a
studentized residuals.
}
\examples{
lmod <- lm(price ~ sqft_living, data = home_sales)
outlier_test(lmod)
outlier_test(lmod, alpha = 1, n = 7)
lmod2 <- lm(Petal.Length ~ Sepal.Length + Species, iris)
outlier_test(lmod2)
}
\seealso{
\code{\link[stats]{rstudent}},
  \code{\link[stats]{p.adjust}}
}
