% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/europeanPutOptionValue.R
\name{europeanPutOptionValue}
\alias{europeanPutOptionValue}
\title{Estimate European Put Option Value}
\usage{
europeanPutOptionValue(
  stock_data,
  future_time,
  sell_value,
  max.p = 5,
  max.q = 5,
  method = "CSS-ML"
)
}
\arguments{
\item{stock_data}{Numeric vector of stock prices data}

\item{future_time}{Numeric constant of the future time}

\item{sell_value}{The numeric sell value of the European put option.}

\item{max.p}{The maximum order of the autoregressive part of the ARMA model (default is set to 5)}

\item{max.q}{The maximum order of the moving average part of the ARMA model (default is set to 5)}

\item{method}{The way that the ARMA model is calculated, accepted values are "ML", "CSS-ML" and "CSS"}
}
\value{
Estimate the value of a European put option, determine the probability of making profits, and model an appropriate ARMA model for the given stock data.
}
\description{
This function calculates the value of a European put option based on stock data, a future time value, and a sell value
}
\examples{
library(stats)
library(forecast)
# Create simulated data
n = 100
set.seed(42)
arma_values = arima.sim(n = n, model = list(ar = c(0.6), ma = c(0.5, -0.5)))
linear_model = 5 + 1:n
stock_data = arma_values + linear_model
europeanPutOptionValue(stock_data = stock_data,future_time = 5,sell_value = 110,max.p = 5,max.q = 5)

}
