% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_palettes.R
\name{ag_call}
\alias{ag_call}
\alias{ag_base}
\alias{ag_highlight}
\alias{ag_positive}
\alias{ag_negative}
\alias{ag_qualitative}
\alias{ag_sequential}
\alias{ag_divergent}
\alias{ag_font}
\title{Consistent palette calls}
\usage{
ag_base()

ag_highlight()

ag_positive()

ag_negative()

ag_qualitative(number)

ag_sequential(number)

ag_divergent(number)

ag_font()
}
\arguments{
\item{number}{Integer of how many category colours to return.}
}
\value{
One or more hexcodes as strings.
}
\description{
These functions assist in calling particular parts of a theme's palette.
For example, \code{ag_base()} will return the current theme's base or background
color, and \code{ag_highlight()} will return the color used in that theme to
highlight one or more nodes, lines, or such.

Using palettes that are high contrast, aesthetically pleasing, and
institutionally or thematically consistent is not without its challenges.
}
\section{Colour blindness}{

The default palettes are designed to be colour-blind friendly.
There are different types of colour-blindness.
The most common type, red-green colour-blindness,
finds it difficult to distinguish between the red and green hues used
in the \href{https://colorspace.r-forge.r-project.org/articles/endrainbow.html}{rainbow palette},
for instance.
Fortunately there are a range of palettes that function fairly well for
those who are color-blind.
These include the \href{https://CRAN.R-project.org/package=viridis}{viridis}
palette,
and the ColorBrewer palettes (included in the RColorBrewer package).
The default palettes in \code{{autograph}} are designed to be colour-blind
friendly, but users should always check that their visualisations serve
their intended audience.
}

