% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_data.R
\name{update_data}
\alias{update_data}
\alias{update_data,data.frame,data.frame,character-method}
\alias{update_data,lib_df,lib_df,missing-method}
\alias{update_data,lib_df,lib_df,character-method}
\alias{update_data<-}
\alias{update_data<-,data.frame,character,data.frame-method}
\alias{update_data<-,lib_df,missing,lib_df-method}
\title{Update data frames}
\usage{
update_data(object, revision, key, ...)

\S4method{update_data}{data.frame,data.frame,character}(
  object,
  revision,
  key,
  add = FALSE,
  delete = FALSE,
  update = FALSE,
  ...
)

\S4method{update_data}{lib_df,lib_df,missing}(object, revision, key, ...)

update_data(object, key, ...) <- value

\S4method{update_data}{data.frame,character,data.frame}(object, key, ...) <- value

\S4method{update_data}{lib_df,missing,lib_df}(object, key, ...) <- value
}
\arguments{
\item{object}{A data frame or a \linkS4class{lib_df} object representing the
original version.}

\item{revision}{The updated version of 'object' to be compared.}

\item{key}{A character value indicating the column used as identifier. This
variable have to be in both versions otherwise this function will
retrieve an error.}

\item{...}{Further arguments passed among methods.}

\item{delete, add, update}{Logical value indicating whether the action
should be carried out. If all are \code{'FALSE'}, this function will just
report differences as done by \link{compare_df}.}

\item{value}{The updated version of 'object' in the replace methods.}
}
\value{
Either an invisible output with a print in the console or an updated object
of class \linkS4class{lib_df}.
}
\description{
This function compares two versions of the same data frame and detect changes
as additions, deleted entries or updates (modified entries).

A method to compare \linkS4class{lib_df} objects is also provided as well as a
replace method.
}
\examples{
# Adding an ID to data set iris
iris2 <- iris
iris2$id <- 1:nrow(iris2)

# rows to add using mean values per species
iris_mod <- aggregate(cbind(
  Sepal.Length, Sepal.Width, Petal.Length,
  Petal.Width
) ~ Species, data = iris2, FUN = mean)
iris_mod$id <- (1:nrow(iris_mod)) + nrow(iris2)
iris_mod <- do.call(rbind, list(iris2, iris_mod[, colnames(iris2)]))

# delete some entries
iris_mod <- iris_mod[-c(15, 75, 105, 145), ]

# modify entries
iris_mod$Petal.Length[c(20, 30)] <- 0
iris_mod$Petal.Width[c(20, 50)] <- 0

# just a comparison
update_data(iris2, iris_mod, key = "id")

# do update
iris2 <- update_data(iris2, iris_mod,
  key = "id", delete = TRUE, add = TRUE,
  update = TRUE
)
}
