% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aa-generics-as_bids_tabular.R,
%   R/class033-bids_phenotype_assessment.R
\name{get_bids_phenotype_data}
\alias{get_bids_phenotype_data}
\alias{BIDSTabularPhenotype}
\title{'BIDS' phenotype and assessment table class}
\usage{
get_bids_phenotype_data(x, ...)

BIDSTabularPhenotype(content, meta = NULL)
}
\arguments{
\item{x}{R object such as file path, project instances, etc.}

\item{...}{passed to other methods or ignored}

\item{content, meta}{see \code{\link{BIDSTabular}}}
}
\value{
A \code{BIDSTabularPhenotype} instance inheriting
\code{\link{BIDSTabular}}.
}
\description{
A tabular containing a list of phenotype & assessment, with their metadata.
The class is a child class of \code{\link{BIDSTabular}}, hence see
the methods there.
The original specification is at
\url{https://bids-specification.readthedocs.io/en/stable/modality-agnostic-files.html#phenotypic-and-assessment-data}.
}
\examples{



BIDSTabularPhenotype(
  meta = list(
    MeasurementToolMetadata = list(
      Description = "Adult ADHD Clinical Diagnostic Scale V1.2",
      TermURL = "https://www.cognitiveatlas.org/task/id/trm_5586ff878155d"
    ),
    adhd_b = list(
      Description = "B. CHILDHOOD ONSET OF ADHD (PRIOR TO AGE 7)",
      Levels = list(
        "1" = "YES",
        "2" = "NO"
      )
    ),
    adhd_c_dx = list(
      Description = "As child met A, B, C, D, E and F diagnostic criteria",
      Levels = list(
        "1" = "YES",
        "2" = "NO"
      )
    )
  ),
  content = data.frame(
    MeasurementToolMetadata = c(2, 3, 4),
    adhd_b = c(1, 2, 1),
    adhd_c_dx = c(2, 1, 2)
  )
)


}
\author{
Zhengjia Wang
}
