% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{Math.scan}
\alias{Math.scan}
\alias{Math.pvol}
\alias{Ops.param}
\alias{Ops.scan}
\alias{Ops.pvol}
\title{Mathematical and arithmetic operations on param's, scan's and pvol's}
\usage{
\method{Math}{scan}(x, ...)

\method{Math}{pvol}(x, ...)

\method{Ops}{param}(e1, e2)

\method{Ops}{scan}(e1, e2)

\method{Ops}{pvol}(e1, e2)
}
\arguments{
\item{x}{object of class \code{scan}, or \code{pvol}}

\item{...}{objects passed on to the Math functions}

\item{e1}{object of class \code{param}, \code{scan}, \code{pvol} or a number}

\item{e2}{object of class \code{param}, \code{scan}, \code{pvol} or a number}
}
\value{
an object of the input class
}
\description{
Mathematical and arithmetic operations on param's, scan's and pvol's
}
\details{
Use caution when applying these manipulations, as there are no
consistency checks if the operations lead to interpretable outcomes.
For example, when averaging scans with logarithmic values (e.g. DBZ), it might be required
to first exponentiate the data before summing.

Attributes are taken from the first object in the operation.

When a \code{pvol} is multiplied by a list, in which case arguments are taken from the list per scan.
this requires the list to have the same length as the number of scans.
}
\examples{
# Locate and read the polar volume example file
scan1 <- example_scan

#add a value of 1 to all scan parameters:
scan2 <- example_scan + 1

# average the scan parameters of two scans:
# NB: requires identical scan parameter names and order!
(scan1 + scan2)/2
}
\seealso{
\itemize{
\item \code{\link[=calculate_param]{calculate_param()}}
}
}
