% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numClust.R
\name{numClust}
\alias{numClust}
\title{Number of Clusters in a Partition or List of Partitions}
\usage{
numClust(clu)
}
\arguments{
\item{clu}{A vector representing a partition or a list of such vectors (partitions). 
Each partition is expected to be a vector of cluster memberships.}
}
\value{
An integer (if `clu` is a single partition) or a vector of integers (if `clu` is a list),
representing the number of clusters in each partition.
}
\description{
Computes the number of clusters (unique groups) in a partition or a list of partitions.
}
\details{
If a single vector is provided, it returns the number of unique cluster labels.
If a list of partitions is provided (e.g., when dealing with multiple sets of units), 
it returns a vector of the number of clusters for each partition in the list.
}
\examples{
# Single partition
numClust(c(1, 1, 2, 2, 3))  # returns 3

# List of partitions
numClust(list(c(1, 1, 2), c(1, 2, 3, 4)))  # returns c(2, 4)

}
