% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmmformula.R
\name{apply_links}
\alias{apply_links}
\title{Apply link functions for parameters in a formula or bmmformula}
\usage{
apply_links(formula, links = nlist())
}
\arguments{
\item{formula}{A \code{formula} or \code{bmmformula} that the links should be applied to}

\item{links}{A list of \code{links} that should be applied to the formula. Each element in this list
should be named using the parameter labels the links should be applied for and contain
a character variable specifying the link to be applied. Currently implemented links are:
"log", "logit", "probit", and "identity".}
}
\value{
The \code{formula} or \code{bmmformula} the links have been applied to
}
\description{
This function applies the specified link functions in the list of \code{links} to the
\code{formula} or \code{bmmformula} that is passed to it. This function is mostly used internally for configuring
\code{bmmodels}.
}
\examples{
# specify a bmmformula
form <- bmf(x ~ a + c, kappa ~ 1, a ~ 1, c ~ 1)
links <- list(a = "log", c = "logit")

apply_links(form, links)
}
\keyword{developer}
