% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{rejection_sampling}
\alias{rejection_sampling}
\title{Rejection Sampling}
\usage{
rejection_sampling(n, f, max_f, proposal_fun, ...)
}
\arguments{
\item{n}{Integer. The number of samples to generate.}

\item{f}{Function. The target density function from which to sample.}

\item{max_f}{Numeric. The maximum value of the target density function \code{f}.}

\item{proposal_fun}{Function. A function that generates samples from the proposal distribution.}

\item{...}{Additional arguments to be passed to the target density function \code{f}.}
}
\value{
A numeric vector of length \code{n} containing samples from the target distribution.
}
\description{
Performs rejection sampling to generate samples from a target distribution.
}
\examples{
target_density <- function(x) brms::dvon_mises(x, mu = 0, kappa = 10)
proposal <- function(n) runif(n, min = -pi, max = pi)
samples <- rejection_sampling(10000, target_density, max_f = target_density(0), proposal)
hist(samples, freq = FALSE)
curve(target_density, col = "red", add = TRUE)
}
\keyword{distribution}
