% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lognormal_distribution.R
\name{lognormal_distribution}
\alias{lognormal_distribution}
\alias{lognormal_pdf}
\alias{lognormal_lpdf}
\alias{lognormal_cdf}
\alias{lognormal_lcdf}
\alias{lognormal_quantile}
\title{Log Normal Distribution Functions}
\usage{
lognormal_pdf(x, location = 0, scale = 1)

lognormal_lpdf(x, location = 0, scale = 1)

lognormal_cdf(x, location = 0, scale = 1)

lognormal_lcdf(x, location = 0, scale = 1)

lognormal_quantile(p, location = 0, scale = 1)
}
\arguments{
\item{x}{quantile}

\item{location}{location parameter (default is 0)}

\item{scale}{scale parameter (default is 1)}

\item{p}{probability (0 <= p <= 1)}
}
\value{
A single numeric value with the computed probability density, log-probability density, cumulative distribution, log-cumulative distribution, or quantile depending on the function called.
}
\description{
Functions to compute the probability density function, cumulative distribution function, and quantile function for the Log Normal distribution.
}
\examples{
# Log Normal distribution with location = 0, scale = 1
lognormal_pdf(0)
lognormal_lpdf(0)
lognormal_cdf(0)
lognormal_lcdf(0)
lognormal_quantile(0.5)
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/dist_ref/dists/lognormal_dist.html}{Boost Documentation} for more details on the mathematical background.
}
