% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootLR.R
\name{drawMaxedOut}
\alias{drawMaxedOut}
\title{Internal function to draw a set of sensitivities or specificities
This is intended for the case where testPos == totalDzPos or testNeg == totalDzNeg.}
\usage{
drawMaxedOut(n, R, consistentQuantile = 0.5, verbose,
  parameters = list(shrink = 5, tol = 5e-04, nEach = 80),
  method = "deterministic")
}
\arguments{
\item{n}{The total number of positives/negatives in the population.}

\item{R}{is the number of replications in each round of the bootstrap (has been tested at 10,000 or greater).}

\item{consistentQuantile}{Defaults to 0.5, i.e. the median. Finds the lowest probability for which the random draws are likely to be consistently one, where consistently is defined by this value (i.e. at .5, a simple majority of the time is enough for consistency)}

\item{verbose}{Whether to display internal operations as they happen.}

\item{parameters}{List of control parameters (shrink, tol, nEach) for sequential search.}

\item{method}{Either "deterministic" or "search". The former is faster and more accurate. Thanks to an anonymous reviewer for pointing out the utility of the binomial distribution in solving this problem.}
}
\description{
Internal function to draw a set of sensitivities or specificities
This is intended for the case where testPos == totalDzPos or testNeg == totalDzNeg.
}
