% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kendall.R
\name{tidy.Kendall}
\alias{tidy.Kendall}
\alias{Kendall_tidiers}
\alias{kendall_tidiers}
\title{Tidy a(n) Kendall object}
\usage{
\method{tidy}{Kendall}(x, ...)
}
\arguments{
\item{x}{A \code{Kendall} object returned from a call to \code{\link[Kendall:Kendall]{Kendall::Kendall()}},
\code{\link[Kendall:MannKendall]{Kendall::MannKendall()}}, or \code{\link[Kendall:SeasonalMannKendall]{Kendall::SeasonalMannKendall()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Two exceptions here are:
\itemize{
\item \code{tidy()} methods will warn when supplied an \code{exponentiate} argument if
it will be ignored.
\item \code{augment()} methods will warn when supplied a \code{newdata} argument if it
will be ignored.
}}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies across models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\examples{
\dontshow{if (rlang::is_installed("Kendall")) withAutoprint(\{ # examplesIf}

# load libraries for models and data
library(Kendall)

A <- c(2.5, 2.5, 2.5, 2.5, 5, 6.5, 6.5, 10, 10, 10, 10, 10, 14, 14, 14, 16, 17)
B <- c(1, 1, 1, 1, 2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 2, 2)

# fit models and summarize results
f_res <- Kendall(A, B)
tidy(f_res)

s_res <- MannKendall(B)
tidy(s_res)

t_res <- SeasonalMannKendall(ts(A))
tidy(t_res)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[Kendall:Kendall]{Kendall::Kendall()}}, \code{\link[Kendall:MannKendall]{Kendall::MannKendall()}},
\code{\link[Kendall:SeasonalMannKendall]{Kendall::SeasonalMannKendall()}}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with columns:
  \item{kendall_score}{Kendall score.}
  \item{p.value}{The two-sided p-value associated with the observed statistic.}
  \item{var_kendall_score}{Variance of the kendall_score.}
  \item{statistic}{Kendall's tau statistic}
  \item{denominator}{The denominator, which is tau=kendall_score/denominator.}

}
