% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robust-glmrob.R
\name{tidy.glmRob}
\alias{tidy.glmRob}
\title{Tidy a(n) glmRob object}
\usage{
\method{tidy}{glmRob}(x, ...)
}
\arguments{
\item{x}{A \code{glmRob} object returned from \code{\link[robust:glmRob]{robust::glmRob()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Two exceptions here are:
\itemize{
\item \code{tidy()} methods will warn when supplied an \code{exponentiate} argument if
it will be ignored.
\item \code{augment()} methods will warn when supplied a \code{newdata} argument if it
will be ignored.
}}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies across models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\details{
For tidiers for robust models from the \pkg{MASS} package see
\code{\link[=tidy.rlm]{tidy.rlm()}}.
}
\examples{
\dontshow{if (rlang::is_installed("robust")) withAutoprint(\{ # examplesIf}

# load libraries for models and data
library(robust)

# fit model
gm <- glmRob(am ~ wt, data = mtcars, family = "binomial")

# summarize model fit with tidiers
tidy(gm)
glance(gm)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[robust:glmRob]{robust::glmRob()}}

Other robust tidiers: 
\code{\link{augment.lmRob}()},
\code{\link{glance.glmRob}()},
\code{\link{glance.lmRob}()},
\code{\link{tidy.lmRob}()}
}
\concept{robust tidiers}
