% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation.R
\name{estimates}
\alias{estimates}
\title{Estimation of Block-Basu Bivariate Pareto (BBBVPA) distribution}
\usage{
estimates(
  I,
  s1.int,
  s2.int,
  a0.int,
  a1.int,
  a2.int,
  tol.est = 1e-05,
  MxIter.no = 2000,
  rate = 1e-04,
  condition = "log.L"
)
}
\arguments{
\item{I}{bivariate observations.}

\item{s1.int}{initial choice of \eqn{\sigma_1}.}

\item{s2.int}{initial choice of \eqn{\sigma_2}.}

\item{a0.int}{initial choice of \eqn{\alpha_0}.}

\item{a1.int}{initial choice of \eqn{\alpha_1}.}

\item{a2.int}{initial choice of \eqn{\alpha_2}.}

\item{tol.est}{convergence tolerance, \code{0.00001} (default).}

\item{MxIter.no}{maximum number of iterations, \code{2000} (default).}

\item{rate}{step size or learning rate for gradient descent, \code{0.0001} (default).}

\item{condition}{convergence criterion, \code{"log.L"} (default) and \code{"p.logL"}.}
}
\value{
object of class "\code{bbbvpa}", a list consisting of
\item{mu1, mu2, sigma1, sigma2, alpha0, alpha1, alpha2, iter.no}{estimates  of parameters and number of iteration.}
\item{data }{the supplied data \code{I}.}
}
\description{
Parameters estimation of BBBVPA distribution.
}
\examples{
\donttest{
# Read data
data(precipitation)
data <- as.vector(precipitation[,2])
data[is.na(data)]<-0
n <- length(data)
# Construct the three-dimensional data set
data3d <- function(data){
 u <- 12
 Y <- c()
 indx <- indx1 <- indx2 <- indx3 <- 0
 r <- 5
 i <- 2
 while(i < n){
   i <- i + 1
   if(data[i] > u || sum(data[(i-1):i]) > u || sum(data[(i-2):i]) > u){
     if(data[i] > u){imax <- i}
     if(sum(data[(i-1):i]) > u){imax <- i - 3 + which(data[(i-1):i] == max(data[(i-1):i]))[1]}
     if(sum(data[(i-2):i]) > u){imax <- i - 3 + which(data[(i-2):i] == max(data[(i-2):i]))[1]}
     if(max(indx) > (imax-r)){
       cluster <- data[(max(indx)+3):(imax+r)]
     } else{
       cluster <- data[(imax-r):(imax+r)]
     }
     cluster2 <- sapply(c(1:(length(cluster)-1)), function(j) sum(cluster[j:(j+1)]))
     cluster3 <- sapply(c(1:(length(cluster)-2)), function(j) sum(cluster[j:(j+2)]))
     indx1 <- append(indx1,imax-r-1+which(cluster==max(cluster))[1])
     indx2 <- append(indx2,imax-r-1+which(cluster2==max(cluster2)))
     indx3 <- append(indx3,imax-r-1+which(cluster3==max(cluster3)))
     Y <- rbind(Y, c(max(cluster),max(cluster2),max(cluster3)))
     indx <- append(indx,imax)
     i <- i + r
   }
 }
 return(Y)
}
I <- data3d(data)[,c(1,3)]
iniz <- intliz(I)
iniz
est <- estimates(I, iniz[1], iniz[2], iniz[3], iniz[4], iniz[5])
est[-9]
param.boot(I, iniz[1], iniz[2], iniz[3], iniz[4], iniz[5])
conf.intv(est)
}

}
\author{
Biplab Paul <paul.biplab497@gmail.com> and Arabin Kumar Dey <arabin@iitg.ac.in>
}
