% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mLf2.R
\name{mLf2}
\alias{mLf2}
\title{Marginal log-liklihood function of variable X2}
\usage{
mLf2(I, mu2, s2, a0, a1, a2)
}
\arguments{
\item{I}{baivariate observations.}

\item{mu2}{value of \eqn{\mu_2}.}

\item{s2}{value of \eqn{\sigma_2}.}

\item{a0}{value of \eqn{\alpha_0}.}

\item{a1}{value of \eqn{\alpha_1}.}

\item{a2}{value of \eqn{\alpha_2}.}
}
\value{
A scalar numeric, the marginal log-liklihood value of variable \eqn{X_2}.
}
\description{
Return the marginal log-liklihood value of variable \eqn{X_2}.
}
\examples{
dat <- rbb.bvpa(500, 0.1, 0.1, 0.8, 0.8, 2.0, 0.4, 0.5)
mLf2(dat, 0.1, 0.8, 2.0, 0.4, 0.5)

}
\author{
Biplab Paul <paul.biplab497@gmail.com> and Arabin Kumar Dey <arabin@iitg.ac.in>
}
