% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/percentileFun.R
\name{pctl.fun}
\alias{pctl.fun}
\title{Survival functions of pivots of estimators of locations.}
\usage{
pctl.fun(z, n, a0, a1, a2, pct, select = 1)
}
\arguments{
\item{z}{quantiles.}

\item{n}{number of observations.}

\item{a0}{value of \eqn{\alpha_0}.}

\item{a1}{value of \eqn{\alpha_1}.}

\item{a2}{value of \eqn{\alpha_2}.}

\item{pct}{probabilities.}

\item{select}{Allows to select the function for different location parameters. a single model term to be selected for printing.
e.g. if you just want the function for \eqn{\mu_1} set \eqn{select=1} (default).}
}
\value{
return a function.
}
\description{
Survival functions of pivots of estimators of locations \eqn{\mu_1} and \eqn{\mu_2}.
These are required to calculate the critical value of confidence intervals for \eqn{\mu_1}
and \eqn{\mu_2}.
}
\examples{
uniroot(pctl.fun, interval=c(0,2), n = 500, a0 = 2.0, a1 = 0.4, a2 = 0.5,
 pct = 0.025, tol = 0.0001)[[1]]

}
\author{
Biplab Paul <paul.biplab497@gmail.com> and Arabin Kumar Dey <arabin@iitg.ac.in>
}
