% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pseuLogLik.R
\name{pseu.logL}
\alias{pseu.logL}
\title{Pseudo log-likelihood function of Block-Basu Bivariate Pareto (BBBVPA) distribution}
\usage{
pseu.logL(I, mu1, mu2, s1, s2, a0, a1, a2)
}
\arguments{
\item{I}{baivariate observations.}

\item{mu1}{value of \eqn{\mu_1}.}

\item{mu2}{value of \eqn{\mu_2}.}

\item{s1}{value of \eqn{\sigma_1}.}

\item{s2}{value of \eqn{\sigma_2}.}

\item{a0}{value of \eqn{\alpha_0}.}

\item{a1}{value of \eqn{\alpha_1}.}

\item{a2}{value of \eqn{\alpha_2}.}
}
\value{
A scalar numeric, pseudo log likelihood of the model.
}
\description{
Return the pseudo log likelihood value.
}
\examples{
dat <- rbb.bvpa(500, 0.1, 0.1, 0.8, 0.8, 2.0, 0.4, 0.5)
pseu.logL(dat, 0.1, 0.1, 0.8, 0.8, 2.0, 0.4, 0.5)

}
\author{
Biplab Paul <paul.biplab497@gmail.com> and Arabin Kumar Dey <arabin@iitg.ac.in>
}
