% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/islamic.R, R/lunar_calendars_astronomy.R
\name{islamic_date}
\alias{islamic_date}
\alias{as_islamic}
\alias{oislamic_date}
\alias{as_oislamic}
\alias{saudi_date}
\alias{as_saudi}
\title{Islamic calendar dates}
\usage{
islamic_date(year = integer(), month = integer(), day = integer())

as_islamic(date)

oislamic_date(year = integer(), month = integer(), day = integer())

as_oislamic(date)

saudi_date(year = integer(), month = integer(), day = integer())

as_saudi(date)
}
\arguments{
\item{year}{A numeric vector of years}

\item{month}{A numeric vector of months}

\item{day}{A numeric vector of days}

\item{date}{Vector of dates on some calendar}
}
\value{
An islamic vector object
}
\description{
The Islamic (or Hijri) calendar is a lunar calendar comprising 12
lunar months in a year of 354 or 355 days. It is widely used in
for Islamic holidays, and in countries where the predominant
religion is Islam.
}
\details{
Three variations are implemented here. The standard Islamic calendar
is available using \code{as_islamic} and \code{islamic_date}. The Saudi Islamic calendar
uses \code{as_saudi} and \code{saudi_date}, while the traditional observational
Islamic calendar is available using \code{as_oislamic} and \code{oislamic_date}.
}
\examples{
islamic_date(2025, 5, 1:30)
as_islamic("2016-01-01")
as_islamic(Sys.Date())
tibble::tibble(
  x = seq(as.Date("2025-01-01"), as.Date("2025-12-31"), by = "day"),
  y = as_islamic(x)
)
islamic_date(2025, 5, 1:10) |> day_of_week()
islamic_date(2025, 4, 19:30)
}
\seealso{
\link{cal_islamic}, \link{ramadan}
}
