% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incidence_rates.R
\name{incidence_rates}
\alias{incidence_rates}
\title{Compute crude incidence rates}
\usage{
incidence_rates(ncan, py, ncan.min = 5)
}
\arguments{
\item{ncan}{integer, number of cancer}

\item{py}{integer, number of person-year}

\item{ncan.min}{integer, minimum number of observation required not to mask the CI's out

Crude incidence rates and associated 95\% confidence interval are computing assuming a Poisson distribution and the exact method.}
}
\value{
a 3 column data.frame containing the crude incidence rate estimate (est) and associated 95\% CI (lci, uci)
}
\description{
Compute crude incidence rates
}
\examples{
ncan <- c(1, 10, 100)
py <- c(10, 100, 1000)
incidence_rates(ncan, py, 5)
}
\references{
Boyle P, Parkin DM. Cancer registration: principles and methods. Statistical methods for registries. IARC Sci Publ. 1991;(95):126-58. PMID: 1894318.
}
\seealso{
\code{\link[epitools:pois.conf.int]{epitools::pois.exact()}}
}
\concept{summary-stat}
