% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CARA_function.R
\name{WBR_Alloc_Surv}
\alias{WBR_Alloc_Surv}
\title{Allocation Function of Weighted Balance Ratio Design for Survival Response}
\usage{
WBR_Alloc_Surv(
  ptsb.X,
  ptsb.Z,
  ptsb.Y,
  ptsb.t,
  ptsb.E,
  ptnow.X,
  ptnow.Z,
  v = 2,
  weight
)
}
\arguments{
\item{ptsb.X}{a vector of length \code{n} of the predictive covariates of previous patients. Must be binary.}

\item{ptsb.Z}{a \code{n x k}  of the prognostic covariates of previous patients. Must be binary.}

\item{ptsb.Y}{a vector of length \code{n} of the responses of previous patients.}

\item{ptsb.t}{a vector of length \code{n} of the treatment allocation of previous patients.}

\item{ptsb.E}{a vector of length \code{n} with value 1 or 0 of the status of event and censoring.}

\item{ptnow.X}{a binary value of the predictive covariate of the present patient.}

\item{ptnow.Z}{a vector of length \code{k} of the binary prognostic covariate of the present patient.}

\item{v}{a positive value that controls the randomness of allocation probability function.}

\item{weight}{a vector of length \code{2+k}. The weight of balance ratio in overall,margin and stratum levels.}
}
\value{
\item{prob}{Probability of assigning the upcoming patient to treatment A.}
}
\description{
Calculating the probability of assigning the upcoming patient to treatment A based on the patient's covariates and the previous patients' covariates and responses for Weighted Balance Ratio procedure for survival response.
}
\examples{
set.seed(123)

# Generate historical data for 400 patients
ptsb.X = sample(c(1, -1), 400, replace = TRUE)  # predictive covariate
ptsb.Z = cbind(
  sample(c(1, -1), 400, replace = TRUE),         # prognostic covariate 1
  sample(c(1, -1), 400, replace = TRUE)          # prognostic covariate 2
)
ptsb.Y = rexp(400, rate = 1)                    # observed time
ptsb.E = sample(c(1, 0), 400, replace = TRUE)   # event indicator (1=event, 0=censored)
ptsb.t = sample(c(1, 0), 400, replace = TRUE)   # treatment assignments

# Incoming patient covariates
ptnow.X = 1
ptnow.Z = c(1, -1)

# Calculate allocation probability using WBR for survival response
result = WBR_Alloc_Surv(
  ptsb.X = ptsb.X,
  ptsb.Z = ptsb.Z,
  ptsb.Y = ptsb.Y,
  ptsb.E = ptsb.E,
  ptsb.t = ptsb.t,
  ptnow.X = ptnow.X,
  ptnow.Z = ptnow.Z,
  weight = rep(0.25, 4)
)

# View probability of assigning to treatment A
result$prob
}
\concept{Weighted Balance Ratio Design}
