% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_esm.R
\name{use_esm}
\alias{use_esm}
\title{Ensemble of Small Models (ESM) in caretSDM}
\usage{
use_esm(x, spp = NULL, n_records = 20)
}
\arguments{
\item{x}{A \code{occurrences} or \code{input_sdm} object containing occurrences.}

\item{spp}{A vector of species names containing the species which the ESM must be applied.
Standard is NULL.}

\item{n_records}{Numeric. Number of species records to apply the ESM. Standard is 20.}
}
\value{
A \code{input_sdm} or \code{occurrences} object with ESM parameters.
}
\description{
This functions set parameters to run a ESM when running \code{train_sdm}.
}
\details{
We supply two different ways to apply the ESM. If species names are provided, then ESM will be
applied only in given species. If a number of species records is provided, then ESM will be
applied in every species with number of records bellow the given threshold. As standard,
\code{use_esm} will be apply to every species with less then 20 records.
}
\examples{
# Create sdm_area object:
sa <- sdm_area(parana, cell_size = 100000, crs = 6933)

# Include predictors:
sa <- add_predictors(sa, bioc) |> select_predictors(c("bio1", "bio4", "bio12"))

# Include scenarios:
sa <- add_scenarios(sa)

# Create occurrences:
oc <- occurrences_sdm(occ, crs = 6933) |> join_area(sa)

# Create input_sdm:
i <- input_sdm(oc, sa)

# Use MEM:
i <- use_esm(i, n_records = 999)

}
\author{
Luíz Fernando Esser (luizesser@gmail.com)
https://luizfesser.wordpress.com
}
