% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggrsurv.R
\name{aggrsurv}
\alias{aggrsurv}
\title{Aggregate data in counting process format}
\usage{
aggrsurv(
  data,
  breaks,
  entry = "entry",
  exit = "exit",
  status = "status",
  id = "id",
  names = c("episode", "entry", "exit", "events", "exposure"),
  ...
)
}
\arguments{
\item{data}{data.frame}

\item{breaks}{vector of time points}

\item{entry}{name of entry date variable}

\item{exit}{name exit date variable}

\item{status}{censoring / event variable}

\item{id}{id variable}

\item{names}{character vector of names of new variables}

\item{...}{additional arguments to lower level functions}
}
\value{
data.table
}
\description{
Aggregate data in counting process format. The aggregation is done within
subject only.
}
\examples{

dat <- data.table::data.table(
  id = c(1, 1, 1, 1, 2, 2, 2),
  entry = as.Date(c(
    "2021-01-01", "2021-01-20", "2021-02-28", "2021-06-01",
    "2021-01-01", "2021-01-14", "2021-09-01"
 )),
  status = c(1, 1, 1, 1, 1, 1, 0),
  x = rnorm(7)
)
dat[, exit := data.table::shift(entry, 1, type="lead"), by=id]
dat[, exit := replace(exit, .N, as.Date("2021-12-31")),
     by = id]

res <- aggrsurv(dat,
  breaks = c(182),
  entry = "entry", exit = "exit", status = "status", id = "id"
)
print(res)
}
