% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{calculate_hmts_index}
\alias{calculate_hmts_index}
\title{Calculate HMTS index only (Hedonic Multilateral Time series re-estimation Splicing)}
\usage{
calculate_hmts_index(
  dataset,
  period_variable,
  dependent_variable,
  continuous_variables,
  categorical_variables,
  reference_period,
  periods_in_year,
  production_since = NULL,
  number_preliminary_periods,
  number_of_observations = NULL,
  resting_points
)
}
\arguments{
\item{period_variable}{variable in the dataset with the period}

\item{dependent_variable}{usually the sale price}

\item{continuous_variables}{vector with quality-determining continues variables (numeric, no dummies)}

\item{categorical_variables}{vector with categorical variables (also dummy)}

\item{reference_period}{period or group of periods that will be set to 100 (numeric/string)}

\item{periods_in_year}{if month, then 12. If quarter, then 4, etc. (default = 4)}

\item{production_since}{1 period in the format of the period_variable. See description above (default = NULL)}

\item{number_preliminary_periods}{number of periods that the index is preliminary. Only works if production_since <> NULL. default = 3}

\item{number_of_observations}{number of observations per period (default = TRUE)}

\item{resting_points}{should analyses values be returned? (default = FALSE)}
}
\value{
$Matrix_HMTS_index table with index series based on estimations with time series re-estimations
$Matrix_HMTS table with estimated values based on time series re-estimations
$Matrix_HMS_index table with index series based on estimations with the hedonic model
$Matrix_HMS table with estimated values based on the hedonic model
$Matrix_HMTS_analysis table with analysis values of the time series model per base period

table with periods, index and number of observations. If resting_points = TRUE, then list with tables. See general description and examples.
}
\description{
Based on a hedonic model, an index is calculated in below steps. See also Ishaak, Ouwehand, Remoy & De Haan (2023).
1: for each period, average imputed prices are calculated with the first period as base period.
2: step 1 is repeated for every possible base period. This result in as many series of imputed values as the number of periods.
3: All series with imputed prices are re-estimated with a Kalman filter (also time series model/state space model)
This step can be turned off with a parameter.
4: The series of imputed values are transformed into index series.
5: a specified (parameter) window is chosen of index figures that continues in the calculation.
This step can be turned off with a parameter.
6: Of the remaining index figures, the geometric average per period is calculated.
The remaining index figures form the final index.
}
\details{
Parameter 'production_since':
To simulate a series, where 1 period a time expires (as in production), a manual choice in the past is possible.
Until this period, all periods are imputed. After that, 1 period is added.

Parameter 'resting_points':
If TRUE, the output is a list of tables. These tables can be called with a $ after the output.
$Index table with periods, index and number of observations
$Window table with the index figures within the chosen window
$Chosen_index_series table with index series before the window splice
$Matrix_HMTS_index table with index series based on re-estimated imputations (time series model)
$Matrix_HMTS table with re-estimated imputations (time series model)
$Matrix_HMTS_index table with index series based on estimated imputations (hedonic model)
$Matrix_HMTS table with estimated imputations (time series model)l
$Matrix_HMTS_analyse table with diagnostic values of the time series model per base period
}
\author{
Farley Ishaak
}
\keyword{internal}
