% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tune_deconv.R
\name{summary.tune_deconv}
\alias{summary.tune_deconv}
\title{Summarising deconvolution tuning}
\usage{
\method{summary}{tune_deconv}(
  object,
  metric = attr(object, "metric"),
  method = attr(object, "method"),
  ...
)
}
\arguments{
\item{object}{dataframe of class \code{'tune_deconv'}.}

\item{metric}{Specifies tuning metric to choose optimal tune: either
"RMSE", "Rsq" or "pearson".}

\item{method}{Either "top" or "overall". Determines how best parameter values
are chosen. With "top" the single top configuration is chosen. With
"overall", the average effect of varying each parameter is calculated using
the mean R-squared across all variations of other parameters. This can give
a more stable choice of final tuning.}

\item{...}{further arguments passed to other methods.}
}
\value{
If \code{method = "top"} prints the row representing the best tuning of
parameters (maximum mean R squared, averaged across subclasses). For method
= "overall", the average effect of varying each parameter is calculated by
mean R-squared across the rest of the grid and the best value for each
parameter is printed. Invisibly returns a dataframe of mean metric values
(Pearson r^2, R^2, RMSE) averaged over subclasses.
}
\description{
\code{summary} method for class \code{'tune_deconv'}.
}
