% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logs.R
\name{fetch_logs}
\alias{fetch_logs}
\title{Fetch job logs from the Civis Platform}
\usage{
fetch_logs(object, limit = 100, ...)
}
\arguments{
\item{object}{A \code{civis_api}, \code{civis_error},  or \code{civis_ml} object.}

\item{limit}{The number of log lines to fetch, the default is 100.}

\item{\dots}{Extra parameters passed to methods, currently unused.}
}
\value{
A list of log messages with class \code{civis_logs}.
}
\description{
Fetch job logs from the Civis Platform
}
\examples{
\dontrun{
m <- civis_ml_fetch_existing(123)
fetch_logs(m)

import <- write_civis(iris, "scratch.mytest")
fetch_logs(import)

query_run <- query_civis(123)
fetch_logs(query_run)

e <- tryCatch(read_civis("asdf;"), error = function(e) e)
fetch_logs(e)
}

}
